libname q 'c:\SASCodeforBook\SASDataSets';


 /*This SAS code provides the information presented in Table 12.7 and in Box 12.1 through
        Box 12.6,and discussed in the sections of the paper on Covariance Structures
         and Treatment Effects*/
Data first; set q.HoustonSchools;

/*This code standardizes the covariates to mean zero*/

Title 'This codes standardizes the covariates by their mean. No Weight statement is used.';
   Proc standard data = first out= standard mean=0;
   var gpropensity3 sfal
        higraddm frrdprob stratio mobility hispprob
        femprob maleprob blackprob lep;
Run;

Title 'This code provides a check that the means are zero';
   proc means data = standard;
   var gpropensity3 sfal
    higraddm frrdprob stratio mobility hispprob
        femprob maleprob blackprob lep;
run;

data standard; set standard;

/*Note: This run produces the results in Table 12.7,Box 12.1, Box 12.2, Box 12.3, and Box 12.4*/
Title 'Reading  Proc Glimmix UNR December 2010  Full Model for Table 12.7 & Boxes';
        Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model reading/denom = treatment period treatment*period
        Gpropensity3 sfal
        higraddm frrdprob stratio mobility hispprob
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =100;
        random period / sub = school (treatment)  type = unr s vcorr  residual;
covtest 'common variance across groups' homogeneity;
covtest 'zerog=no G-side' zerog /cl wald estimates;
covtest 'independent=no G-side,diagonal R-side' INDEP /cl wald estimates;
covtest 'diagr=G-side unmodified, diagonal R-side' /cl wald estimates;
covtest 'diagonal = diagonal g-side,R-side unchanged' Diagg /cl wald estimates;
covtest 'homogeneous off diagonal correlations' general
        0 0 0 1 -1,
        0 0 0 1  0 -1
         /estimates;
covtest 'cs'
        general 1 -1,
                1  0 -1,
                0  0  0 1 -1,
                0  0  0 1  0 -1 /estimates;
run;


Title 'Math Proc Glimmix UNR December 2010 for Table 12.7';
        Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model Math/denom = treatment period treatment*period
        sfal Gpropensity3
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =145;
        random period / sub = school (treatment)  type = unr s vcorr  residual;
        *covtest 'common variance across groups' homogeneity;
        covtest 'zerog=no G-side' zerog /cl wald estimates;
        covtest 'independent=no G-side,diagonal R-side' INDEP /cl wald estimates;
        covtest 'diagr=G-side unmodified, diagonal R-side' /cl wald estimates;
        covtest 'diagonal = diagonal g-side,R-side unchanged' Diagg /cl wald estimates;
        covtest 'homogeneous off diagonal correlations, heterogeneous CS' general
        0 0 0 1 -1,
        0 0 0 1  0 -1 /estimates;
        covtest 'cs'
        general 1 -1,
                        1  0 -1,
                        0  0  0 1 -1,
            			0  0  0 1  0 -1 /estimates;
run;


Title 'Ave. of Math and Reading UNR December 2010 base + covariates';
        Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model avemard/denom = treatment period treatment*period
        higraddm frrdprob stratio mobility Hispprob
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =295;
        random period / sub = school(treatment)  type = unr s vcorr  residual;
        *covtest 'common variance across groups' homogeneity;
        covtest 'zerog=no G-side' zerog /cl wald estimates;
        covtest 'independent=no G-side,diagonal R-side' INDEP /cl wald estimates;
        covtest 'diagr=G-side unmodified, diagonal R-side' /cl wald estimates;
        covtest 'diagonal = diagonal g-side,R-side unchanged' Diagg /cl wald estimates;
        covtest 'homogeneous off diagonal correlations' general
        0 0 0 1 -1,
        0 0 0 1  0 -1 /estimates;
        covtest 'cs'
        general 1 -1,
                1  0 -1,
                0  0  0 1 -1,
                0  0  0 1  0 -1 /estimates;
run;

Title 'G4 Writing in Proc Glimmix UNR December 2010  base + SFA + Gpropensity3';
        Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model G4Write/denom = treatment period treatment*period  sfal Gpropensity3
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =1000;
        random period / sub = school (treatment)  type = unr s vcorr  residual;
        *covtest 'common variance across groups' homogeneity;
        covtest 'zerog=no G-side' zerog /cl wald estimates;
        covtest 'independent=no G-side,diagonal R-side' INDEP /cl wald estimates;
        covtest 'diagr=G-side unmodified, diagonal R-side' /cl wald estimates;
        covtest 'diagonal = diagonal g-side,R-side unchanged' Diagg /cl wald estimates;
        covtest 'homogeneous off diagonal correlations' general
        0 0 0 1 -1,
        0 0 0 1  0 -1
         /estimates;
        covtest 'cs'
        general 1 -1,
                1  0 -1,
                0  0  0 1 -1,
                0  0  0 1  0 -1 /estimates;
run;


        /*Code For the last row of Table 12.7, Nuanced Choices of Covariance Structures*/

Title 'Reading Nuanced Structure=CS December 2010, Full Model, Table 12.7 last row, Box 12.5';
        Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model Reading/denom = treatment period treatment*period  sfal gpropensity3
        higraddm frrdprob stratio mobility Hispprob
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =20;
        random period / sub = school (treatment) type = cs s residual vcorr;
        run;


Title 'Math Nuanced Structure = Toeplitz (2) December 2010, Table 12.7 last row';
        Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model Math/denom = treatment period treatment*period  sfal gpropensity3
        higraddm frrdprob stratio mobility Hispprob
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =20;
        random period / sub = school (treatment) type = toep(2) s residual vcorr;
run;

Title 'Ave.Math and Reading Nuanced Structure = CS December 2010, Table 12.7 last row';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model avemard/denom = treatment period treatment*period  gpropensity3 sfal
        higraddm frrdprob stratio mobility Hispprob
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =20;
        random period / sub = school(treatment)  type = cs residual vcorr;
run;

Title'G4Writing Nuanced Structure=UN(1)Banded Main Diagonal December 2010, Table 12.7 last row';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
        Class school treatment period;
        Model g4write/denom = treatment period treatment*period
        sfal Gpropensity3
        higraddm frrdprob stratio  mobility Hispprob
        / cl solution dist=binomial link=logit ;
        nloptions maxiter =30;
        random period / sub = school(treatment)  type = un(1) s residual vcorr;
run;

                                        /* This concludes the code for Table 12.7*/

/*The following code is used to clarify the interpretation of the treatment effects and to provide
the data for Box 12.5 and Box 12.6.  Note that the reading example now uses the compound symmetry
covariance structure. Boxes 12.1 through 12.4 used the unstructured covariance structure.*/

data standard; set standard;
Title 'Reading in Proc Glimmix CS September 2010, Full Model, Box 12.5 and Box 12.6.';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint ;
        Class school treatment period;
        Model reading/denom = treatment period treatment*period
        sfal Gpropensity3
        higraddm frrdprob stratio mobility Hispprob
        / cl solution dist=binomial link=logit;
        nloptions maxiter =50;
        random period / sub = school(treatment)  type = cs s residual vcorr;
        lsmeans  treatment*period / odds ilink cl ;
        lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
                1 -1 0  -1 1 0 /or ilink cl;
Title2 'Difference in differences estimator for first two time periods';
        *for the target group this estimates the difference between the means;
        estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;
        *for the comparison group this estimates the difference between the means;
        estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
        *this estimates the difference between the differences;
        estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
        *for the target group this estimates the difference between the means;
        estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl;
        *this  gets the difference between means for the third time period relative to the first, null treatment;
        estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl;
        *this estimates the difference between the two differences above;
        estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl;
Title4 'Difference in differences estimator for the third time period relative to the second';
        *for the target group this estimates the difference between the means;
        estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;
        *this gets the difference between means for the third time period relative to the second, null group;
        estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;
        *this estimates the difference between the two differences above;
        estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl;
run;


                /*The code for Table 12.7 and Boxes 12.1 through 12.6 is now complete*/
				/*The syntax in this file is copyright by Robert B. Smith,  2011*/
